<?php

/**
 * Created by IntelliJ IDEA.
 * User: Bertty
 * Date: 23/12/15
 * Time: 12:08
 */
class StmtBD extends mysqli_stmt{
    private static $usuario;
    private $tipo;
    private $tabla;
    private $idTabla;
    private $conexion;

    public function __construct($link, $query)
    {
        parent::__construct($link);
        $this->conexion = $link;

        $this->prepare($query);

        $query = str_replace(array('\t',"\r\n", "\n", "\r"), '', $query);


        $array = explode(' ', $query);

        $this->tipo = $array[0];

        switch(strtolower($this->tipo) ){
            case 'insert':
            	if(strtolower($array[1])== 'ignore'){
            		$array[2] = $array[3];
            	}
            case 'delete':
                $this->tabla = $array[2];
                break;
            case 'update':
                $this->tabla = $array[1];
                break;
            default:
                $this->tabla = '';
                break;
        }
    }

    public function fetch(){
        return parent::fetch();
    }

    public function execute()
    {
        switch(strtolower($this->tipo) ){
            case 'insert':
                parent::execute();				
                $this->idTabla = $this->insert_id;
                $this->close();
                $this->generateLog();
                break;
            case 'update':
                parent::execute();
                $this->close();
                $this->generateLog();
                break;
            case 'delete':
                $this->generateLog();
                parent::execute();
                $this->close();
                break;
            default:
                parent::execute();
                break;
        }

    }

    public function generateLog(){
        switch(strtolower($this->tipo) ){
            case 'insert':
                $stmt = $this->conexion->prepare('call logsCrear(?, ?, ?)');
                $stmt->bind_param('sii', $this->tabla, $this->idTabla, StmtBD::$usuario);
                $stmt->execute();
                $stmt->close();
                break;
            case 'update':
                //echo 'update';
                $stmt = $this->conexion->prepare('call logsActualizar(?, ?, ?)');
                $stmt->bind_param('sii', $this->tabla, $this->idTabla, StmtBD::$usuario);
                $stmt->execute();
                $stmt->close();
                echo $this->conexion->error;
                break;
            case 'delete':
               // echo 'delete';
                $stmt = $this->conexion->prepare('call logsEliminar(?, ?, ?)');
                $stmt->bind_param('sii', $this->tabla, $this->idTabla, StmtBD::$usuario);
                $stmt->execute();
                $stmt->close();
                break;
            default:
                break;
        }
    }


    public static function setUsuario($user){
        StmtBD::$usuario = $user;
    }

    public function log($id){
        $this->idTabla = $id;
    }

    public function getId(){
        return $this->idTabla;
    }
}