<?php
	function consulta_inf(){
		$consulta =  utf8_decode("
		SELECT
			ind.WID_objetivo,
			ind.WID_indicador,
			ind.WID_unidad,
			ind.WID_proceso,
			an.WID_año,
			ROUND(
				(
					SUM(
						DISTINCT cant_infor_corr_mensual
					) * 100
				) / SUM(
					DISTINCT ing.cant_informes_mensual
				),
				3
			),
			sem.WID_semestre
		FROM
			DW_resumen_mensual_ingresos ing
		INNER JOIN DW_fechas fch ON fch.WID_semestre = ing.WID_semestre
		AND fch.WID_año = ing.WID_año
		AND fch.WID_mes = ing.WID_mes
		INNER JOIN DW_meses m ON m.WID_mes = ing.WID_mes
		INNER JOIN DW_semestres sem ON sem.WID_semestre = ing.WID_semestre
		INNER JOIN DW_años an ON an.WID_año = ing.WID_año
		INNER JOIN DW_indicadores ind ON ind.WID_indicador = 1
		WHERE
			DATE_FORMAT(fch.fecha, '%m') < MONTH (NOW())
		GROUP BY
			ing.WID_semestre");
		return $consulta;
	}
	function consulta_encu($aumentador){
		$indicador = 4 + $aumentador;
		$filtro = 1 + $aumentador;
		$consulta2 = utf8_decode("
			SELECT
				indi.WID_objetivo,
				indi.WID_indicador,
				indi.WID_unidad,
				indi.WID_proceso,
				me.WID_año,
				ROUND(SUM(enc.suma_general)/SUM(enc.cant_clien_respond),2)
			FROM
				DW_resumen_mensual_encuestas enc
			INNER JOIN DW_preguntas preg ON preg.WID_pregunta = enc.WID_pregunta
			INNER JOIN DW_tipos_ingresos tin ON tin.WID_tipo_ingreso = enc.WID_area
			INNER JOIN DW_indicadores indi on indi.WID_indicador=$indicador
			INNER JOIN DW_meses me ON me.WID_mes = enc.WID_mes
			WHERE enc.WID_area = $filtro
		");
		return $consulta2;
	}
	function consulta_rec(){
		$consulta = utf8_decode("
				SELECT
					indi.WID_objetivo,
					indi.WID_indicador,
					indi.WID_unidad,
					indi.WID_proceso,
					an.WID_año,
					ROUND(SUM(DISTINCT  rec.cant_reclamos_mensual)*100/SUM(DISTINCT rec.cant_trab_realiz_mensual),3)
				FROM
					DW_resumen_mensual_reclamos rec
				INNER JOIN DW_meses me ON me.WID_mes = rec.WID_mes
				INNER JOIN DW_años an ON an.WID_año = rec.WID_año
				INNER JOIN DW_area ar ON ar.WID_area=rec.WID_area
				INNER JOIN DW_indicadores indi on indi.WID_indicador=2
				GROUP BY
					rec.WID_año
		");
		return $consulta;
	}
	function consulta_recSNP(){
		$consulta = utf8_decode("
				SELECT
					indi.WID_objetivo,
					indi.WID_indicador,
					indi.WID_unidad,
					indi.WID_proceso,
					an.WID_año,
					ROUND(SUM(DISTINCT  rec.cant_reclamosOI_mensual)*100/(SUM(DISTINCT rec.cant_trab_realiz_mensual)*indi.multiplicador),3)
				FROM
					DW_resumen_mensual_reclamos rec
				INNER JOIN DW_meses me ON me.WID_mes = rec.WID_mes
				INNER JOIN DW_años an ON an.WID_año = rec.WID_año
				INNER JOIN DW_area ar ON ar.WID_area=rec.WID_area
				INNER JOIN DW_indicadores indi on indi.WID_indicador=3
				GROUP BY
					rec.WID_año
		");
		return $consulta;
	}
?>