<?php
	function consulta1(){
	$consulta1 = utf8_decode("
				SELECT
					DATE_FORMAT(fch.fecha,'%Y-%m') AS fecha,
					fch.WID_año AS año,
					fch.WID_semestre AS semestre,
					fch.WID_mes AS mes,
					ti.WID_tipo_ingreso AS tIngreso,
					tmu.WID_tipo_muestra AS tMuestra,
					IF(tana.WID_tipo_analisis IS NULL,0,tana.WID_tipo_analisis) AS tAnalisis,
					count(DISTINCT ing.id_ingreso) AS c_ingreso,
					count(DISTINCT mu.id_muestra) AS c_muestra,
					count(DISTINCT ana.id_analisis) AS c_analisis,
					count(DISTINCT ing.id_ingreso) AS c_inform,
					COUNT(
						DISTINCT
						IF (
							ing.raya IS NOT NULL
							AND ing.raya LIKE '%-1%',
							CONCAT(
								ing.WID_ingreso,
								'/',
								ing.raya
							),
							NULL
						)
					) AS inf_corregidos
				FROM
					PDW_ingresos ing
				LEFT JOIN PDW_fechas fch ON fch.fecha = ing.fecha_ingreso
				LEFT JOIN PDW_tipos_ingresos ti ON ti.id_tipo_ingreso = ing.id_tipo_ingreso
				LEFT JOIN PDW_muestras mu ON mu.id_ingreso = ing.id_ingreso
				LEFT JOIN PDW_tipos_muestras tmu ON tmu.id_tipo_muestra = mu.id_tipo_muestra
				LEFT JOIN PDW_analisis ana ON ana.id_muestra = mu.id_muestra
				LEFT JOIN PDW_tipos_analisis tana ON tana.id_tipo_analisis = ana.id_tipo_analisis
				WHERE
					DATE_FORMAT(ing.fecha_ingreso,'%Y-%m') >= '2017-01'
				GROUP BY
					fch.WID_año,
					fch.WID_semestre,
					fch.WID_mes,
					ing.id_tipo_ingreso,
					tmu.id_tipo_muestra,
					ana.id_tipo_analisis
			");
			return $consulta1;
	}
	function consulta2(){
		$consulta2 = utf8_decode("
				SELECT
					DATE_FORMAT(encu.fecha,'%Y-%m'),
					fch.WID_mes,
					encu.area,
					preg.WID_pregunta,
					sum(encu.valor_pregunta) as valor_total,
					count(encu.id_contacto) as total_respondieron
				FROM
					PDW_encuestas encu
				LEFT JOIN PDW_preguntas preg ON preg.id_pregunta = encu.id_pregunta
				LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(encu.fecha)
				WHERE
				 encu.valor_pregunta IS NOT NULL AND DATE(encu.fecha) >= '2017-01-01'
				GROUP BY DATE_FORMAT(fch.fecha, '%Y-%m'),encu.id_pregunta,encu.area
		");
		return $consulta2;
	}
	function consulta3(){
		$consulta3 = utf8_decode("
				SELECT
					DATE_FORMAT(fch.fecha,'%Y-%m') as fecha,
					fch.WID_año AS año,
					fch.WID_mes AS mes,
					ar.WID_area AS area,
					SUM(IF(rec.flag_ea = 1, 1, 0)) AS cant_reclamos,
					SUM(IF(rec.flag_oi = 1, 1, 0)) AS cant_recl_snp,

				IF (
					ar.WID_area IN (5, 6, 7),
					(
						SELECT
							count(WID_ingreso)
						FROM
							PDW_ingresos
						WHERE
							DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
						AND raya IS NULL
						AND id_cliente != 831
						AND id_tipo_ingreso = (
							CASE
							WHEN ar.WID_area = 5 THEN
								1
							WHEN ar.WID_area = 6 THEN
								2
							WHEN ar.WID_area = 7 THEN
								3
							ELSE
								ar.WID_area
							END
						)
					),
					(
						SELECT
							count(WID_ingreso)
						FROM
							PDW_ingresos
						WHERE
							DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
						AND raya IS NULL
						AND id_cliente != 831
					)
				) AS cant_trab_realiz,
				 (
					SELECT
						count(WID_reclamo)
					FROM
						PDW_reclamos
					WHERE
						DATE_FORMAT(fh_cierre, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
					AND flag_ea = 1
				) AS cant_recl_mensual,
				 (
					SELECT
						count(WID_reclamo)
					FROM
						PDW_reclamos
					WHERE
						DATE_FORMAT(fh_cierre, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
					AND flag_oi = 1
				) AS cant_recl_snp_mensual,
				 (
					SELECT
						count(*)
					FROM
						PDW_ingresos
					WHERE
						DATE_FORMAT(fecha_ingreso, '%Y-%m') = date_format(fch.fecha, '%Y-%m')
					AND raya IS NULL
					AND id_cliente != 831
				) AS cant_trabaj_realiz_mensual
				FROM
					PDW_reclamos rec
				LEFT JOIN PDW_fechas fch ON fch.fecha = rec.fh_cierre
				LEFT JOIN PDW_area ar ON ar.area = rec.area
				WHERE
					DATE_FORMAT(rec.fh_cierre,'%Y-%m') >= '2017-01'
				GROUP BY
					fch.WID_año,
					fch.WID_mes,
					date_format(fch.fecha, '%Y-%m'),
					ar.WID_area
		");
		return $consulta3;
	}
?>